// XISLDoc.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "XISLDoc.h"
#include "Mainfrm.h"
#include "InteractionToolView.h"
#include "IBXISLView.h"
#include "IBFlowView.h"
#include "XISLTag.h"
#include "XISLVarList.h"
#include "XISLVar.h"
#include "XISLDialogTag.h"
#include "XISLBeginTag.h"
#include "XISLCombExchangeTag.h"
#include "XISLCallTag.h"
#include "XISLAssignTag.h"
#include "XISLActTag.h"
#include "XISLSwitchTag.h"
#include "XISLCaseTag.h"
#include "XISLIfTag.h"
#include "XISLIfChildTag.h"
#include "XISLCombInputTag.h"
#include "XISLInputTag.h"
#include "XISLSpeechInputTag.h"
#include "XISLTouchInputTag.h"
#include "XISLReturnTag.h"
#include "XISLOutputTag.h"
#include "XISLOutputFSM.h"
#include "XISLOutputTTS.h"
#include "XISLOutputBrowser.h"
#include "XISLPrompt.h"
#include "XISLRepromptTag.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInteractionToolView *pIToolView;
extern CXISLRootTag *g_pAppRootTag;
extern CXISLVarList *g_pAppVarList;
/////////////////////////////////////////////////////////////////////////////
// CXISLDoc

IMPLEMENT_DYNCREATE(CXISLDoc, CDocument)

CXISLDoc::CXISLDoc()
{
	nDoctyp = 0;
	m_pXISLRoot = NULL;
	TRACE("CXISLDoc::쐬\n");
}

BOOL CXISLDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	TRACE("xislf[^쐬\n");
	CreateNewData();
	((CMainFrame*)AfxGetMainWnd())->SetBarItem(ID_DROPOK_DIALOG);
	return TRUE;
}

CXISLDoc::~CXISLDoc()
{
	if(m_pXISLRoot)
	{
		delete m_pXISLRoot;
		m_pXISLRoot = NULL;
	}
}


BEGIN_MESSAGE_MAP(CXISLDoc, CDocument)
	//{{AFX_MSG_MAP(CXISLDoc)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXISLDoc ff

#ifdef _DEBUG
void CXISLDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CXISLDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CXISLDoc VACY

void CXISLDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂ
		POSITION pos = GetFirstViewPosition();
		while(pos)
		{
			UpdateAllViews(NULL,nDoctyp);
			CView* pView = GetNextView(pos);
			if (pView->IsKindOf(RUNTIME_CLASS(CIBXISLView)))
			{
				((CIBXISLView*)pView)->SerializeRaw(ar);
				return;
			}
		}
		ASSERT(NULL);
/*
		CMainFrame* pFrame=(CMainFrame*)AfxGetApp()->m_pMainWnd;
		CChildFrame *pChildFrm = (CChildFrame *) pFrame->GetActiveFrame();
		CIBXISLView *pView = (CIBXISLView*)pChildFrm->m_tabWnd.getTabView(ID_TAB_XISL);

		pView->SerializeRaw(ar);
*/
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂ
		IXMLDOMDocument2Ptr spDOMDoc;
		CString strFolder = ar.GetFile()->GetFilePath();
		int nIndex = strFolder.Find(ar.GetFile()->GetFileName());
		strFolder.Delete(nIndex-1,strFolder.GetLength()-nIndex+1);
		SetCurrentDirectory(strFolder);
		m_strBaseFilePath = strFolder;
		if(LoadXISL(ar.GetFile()->GetFilePath(),spDOMDoc) != 0)
		{
			//CreateNewData();
			return;
		}
		m_strFileName = ar.GetFile()->GetFileName();
		if(AnalyzeXISL(ar.GetFile()->GetFilePath(),spDOMDoc) != 0)
		{
			//CreateNewData();
			delete m_pXISLRoot; m_pXISLRoot = NULL;
			return;
		}
		((CMainFrame*)AfxGetApp()->m_pMainWnd)->ReplaceNCDTag2DTag(m_pXISLRoot);
		nDoctyp |= ID_VIEW_XISL;
		UpdateAllViews(NULL,nDoctyp);
		pIToolView->SendMessage(MY_UPDATE_VIEW,(WPARAM)this,nDoctyp);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CXISLDoc R}h
BOOL CXISLDoc::GetAbsolutePath(CString &strRelativePath,CString &strResultPath)
{
	strResultPath = m_strBaseFilePath;
	strRelativePath.Replace("/","\\");
	if(strResultPath[strResultPath.GetLength()-1] == '\\')
		strResultPath.Delete(strResultPath.GetLength()-1);

	CString strTemp;
	int nIndex = strRelativePath.Find("\\",0);
	while(nIndex != -1)
	{
		strTemp = strRelativePath.Left(nIndex);
		strRelativePath.Delete(0,nIndex);

		if(strTemp.Compare("..") == 0)
		{
			int nIndex2 = strResultPath.ReverseFind('\\');
			if(nIndex2 == -1)
				return FALSE;
			else
				strResultPath.Delete(nIndex2,strResultPath.GetLength()-nIndex2);
		}
		else if(strTemp.Compare(".") != 0)
		{
			strResultPath += "\\";
			strResultPath += strTemp;
		}
		nIndex = strRelativePath.Find("\\",0);
	}
	strResultPath += "\\";
	strResultPath += strRelativePath;
	return TRUE;
}

//int CXISLDoc::LoadXISL(LPCTSTR lpszFilePath,IXMLDOMDocument2Ptr &spDOMDoc)
//w肳ꂽXISLt@CDOMɎ荞
//LPCTSTR lpszFilePath			:pXt̃t@C
//IXMLDOMDocument2Ptr &spDOMDoc	:i[DOM̃X}[g|C^
//F@0 sF0ȊO
int CXISLDoc::LoadXISL(LPCTSTR lpszFilePath,IXMLDOMDocument2Ptr &spDOMDoc)
{
	try
	{
		//DOM̐
		HRESULT hr = spDOMDoc.CreateInstance(CLSID_DOMDocument);
		if(FAILED(hr)){ throw -1; }

		//񓯊ǂݍ݂LZ
		spDOMDoc->put_async(VARIANT_FALSE);
		//DTD؂ɐݒ
		spDOMDoc->put_validateOnParse(VARIANT_FALSE);
		//GeBeBWJs
		spDOMDoc->put_resolveExternals(VARIANT_TRUE);

		VARIANT_BOOL vbRet;
		hr = spDOMDoc->load(_variant_t(lpszFilePath),&vbRet);
		if(FAILED(hr)){ throw -2; }
		
		//p[XG[̕\
		IXMLDOMParseErrorPtr spDOMError;
		long lErrorCode = E_FAIL;
		long lErrorLine;
		BSTR bstrReason;

		spDOMDoc->get_parseError(&spDOMError);
		spDOMError->get_errorCode(&lErrorCode);
		spDOMError->get_line(&lErrorLine);
		if( lErrorCode != 0 )
		{
			spDOMError->get_reason(&bstrReason);
			CString strError;
			strError.Format("%lf :",lErrorLine);
			strError += bstrReason;
			AfxMessageBox(strError);
			throw -3;
		}
	}
	catch ( int nCode ) {
		// G[
		CString strMsg;
		switch ( nCode ) {
			case -1 : { strMsg = "Can't Create Instance"; break; }
			case -2 : { strMsg = "Failed to load xisl file!"; break; }
			case -3 : { strMsg = "DTDG[ł"; break; }
			default : { strMsg = "Unknown error code!"; break; }
		}
		AfxMessageBox(strMsg,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
		return nCode;
	}
	return 0;
}

int CXISLDoc::ReLoadXISL(LPCTSTR lpszXISL)
{
	if(m_pXISLRoot)
	{
		delete m_pXISLRoot;
		m_pXISLRoot = NULL;
	}
	IXMLDOMDocument2Ptr spDOMDoc;
	try
	{
		//DOM̐
		HRESULT hr = spDOMDoc.CreateInstance(CLSID_DOMDocument);
		if(FAILED(hr)){ throw -1; }

		//񓯊ǂݍ݂LZ
		spDOMDoc->put_async(VARIANT_FALSE);
		//DTD؂ɐݒ
		spDOMDoc->put_validateOnParse(VARIANT_FALSE);
		//GeBeBWJs
		spDOMDoc->put_resolveExternals(VARIANT_TRUE);

		VARIANT_BOOL vbRet;
		BSTR bstrXISL = CString(lpszXISL).AllocSysString();
		hr = spDOMDoc->loadXML(bstrXISL,&vbRet);
		SysFreeString(bstrXISL);
		if(FAILED(hr)){ throw -2; }
		
		//p[XG[̕\
		IXMLDOMParseErrorPtr spDOMError;
		long lErrorCode = E_FAIL;
		long lErrorLine;
		BSTR bstrReason;

		spDOMDoc->get_parseError(&spDOMError);
		spDOMError->get_errorCode(&lErrorCode);
		spDOMError->get_line(&lErrorLine);
		if( lErrorCode != 0 )
		{
			spDOMError->get_reason(&bstrReason);
			CString strError;
			strError.Format("%lf :",lErrorLine);
			strError += bstrReason;
			AfxMessageBox(strError);
			throw -3;
		}

		int nRet = AnalyzeXISL(m_strFileName,spDOMDoc);
		if(nRet != 0)
		{
			delete m_pXISLRoot; m_pXISLRoot = NULL;
			throw nRet-3;
		}

		((CMainFrame*)AfxGetApp()->m_pMainWnd)->ReplaceNCDTag2DTag(m_pXISLRoot);
		UpdateAllViews(NULL,nDoctyp|ID_VIEW_RESET);
		POSITION pos = GetFirstViewPosition();
		while(pos)
		{
			CView* pView = GetNextView(pos);
			if (pView->IsKindOf(RUNTIME_CLASS(CIBFlowView)))
				((CIBFlowView*)pView)->ReDrawXISLTag(m_pXISLRoot);
		}
		pIToolView->SendMessage(MY_UPDATE_VIEW,(WPARAM)this,nDoctyp);
	}
	catch ( int nCode ) {
		// G[
		CString strMsg;
		switch ( nCode ) {
			case -1 : { strMsg = "Can't Create Instance"; break; }
			case -2 : { strMsg = "Failed to load xisl file!"; break; }
			case -3 : { strMsg = "DTDG[ł"; break; }
			default : { strMsg = "Unknown error code!"; break; }
		}
		AfxMessageBox(strMsg,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
		return nCode;
	}
	return 0;
}

//int CXISLDoc::AnalyzeXISL(IXMLDOMDocument2Ptr &spDOMDoc)
//DOM͂ĎOCXISLTagIuWFNg𐶐
//F0@sF0ȊO
int CXISLDoc::AnalyzeXISL(LPCTSTR lpszFilePath,IXMLDOMDocument2Ptr &spDOMDoc)
{
	try
	{
		//[g̉
		IXMLDOMElementPtr spDOMRoot;
		VARIANT vValue;
		HRESULT hr = spDOMDoc->get_documentElement(&spDOMRoot);
		if(FAILED(hr)){ throw -1; }

		BSTR bstrName;
		spDOMRoot->get_nodeName(&bstrName);
		CString strName = bstrName;
		SysFreeString(bstrName);
		if(strName.Compare("xisl") != 0){ throw -2; }

		spDOMRoot->getAttribute(SysAllocString(L"version"),&vValue);
		CString strVersion = vValue.bstrVal;
//		if(strVersion.Compare("1.0") != 0){ throw -5; }
		VariantClear(&vValue);
		
		spDOMRoot->getAttribute(SysAllocString(L"application"),&vValue);
		CString strApp = vValue.bstrVal;
		VariantClear(&vValue);

		m_pXISLRoot = new CXISLRootTag;
		//applicationȂȂC̃hLgAvP[V[g
		if(strApp.IsEmpty())
		{
			g_pAppRootTag = (CXISLRootTag*)SetUpAppRoot();
			g_pAppRootTag->SetAppRootName(m_strFileName);
		}
		else
		{
			//applicationw肵ĂȂAɂ̃hLgǂݍ
			if(g_pAppRootTag == NULL)
				((CIBApp*)AfxGetApp())->OpenXISLFrm(strApp);
			else if(strcmp(g_pAppRootTag->GetAppRootName(),strApp) != 0)
				throw -3;
		}

		//document_var̉
		IXMLDOMNodePtr spDOMNode;
		hr = spDOMRoot->selectSingleNode(SysAllocString(L".//document_var"),&spDOMNode);
		if(spDOMNode)
		{
			AnalyzeVar(spDOMNode,m_pXISLRoot);
		}

		//dialog^O̎擾
		long lLen;
		IXMLDOMNodePtr spDOMDialog;
		IXMLDOMNodeListPtr spDOMDialogList;
		hr = spDOMDoc->getElementsByTagName(CComBSTR(XISL_TAG_NAME[ID_TAG_DIALOG]),&spDOMDialogList);
		spDOMDialogList->get_length(&lLen);
		for(int i=0;i<lLen;i++)
		{
			spDOMDialogList->get_item(i,&spDOMDialog);
			if(spDOMDialog)
			{
				int nRet = AnalyzeDialogChildren(spDOMDialog,m_pXISLRoot);
				if(nRet == -2){ throw -4; }
			}
		}

//		if(FAILED(hr)){ throw -2; }
	}
	catch ( int nCode ) {
		// G[
		CString strMsg;
		switch ( nCode ) {
			case -1 : { strMsg = "Can't get Root node"; break; }
			case -2 : { strMsg = "[g<xisl>ł͂܂"; break; }
			case -3 : { strMsg = "AvP[V[gݍƒ̂̂ƈႤt@C͓ǂݍ߂܂";break;}
			case -4 : { strMsg = "IuWFNg̐s"; break; }
			case -5 : { strMsg = "xisl̃@[WႢ܂"; break; }
			default : { strMsg = "Unknown error code!"; break; }
		}
		delete m_pXISLRoot;
		m_pXISLRoot = NULL;
		AfxMessageBox(strMsg,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
		return nCode;
	}
	return 0;
}

//int CXISLDoc::AnalyzeVar(IXMLDOMNodePtr &spDOMParentVar,CXISLTag *pParentTag)
//document_var,dialog_var,exchange_var
//IXMLDOMNodePtr &spDOMParentVar	:͑Ώۂ̃m[h(document_var,dialog_var,exchange_var)
//CXISLTag *pParentTag				:ǉΏۂ̃^O(xisl,dialog,exchange)
//F0 sF0ȊO
int CXISLDoc::AnalyzeVar(IXMLDOMNodePtr &spDOMParentVar,CXISLTag *pParentTag)
{
	CXISLVarList *pVarList;
	int nType = pParentTag->m_nTagType;
	switch(nType)
	{
	case ID_TAG_XISL:
		pVarList = ((CXISLRootTag*)pParentTag)->m_pDocumentVar;
		break;
	case ID_TAG_DIALOG:
		pVarList = ((CXISLDialogTag*)pParentTag)->m_pDialogVar;
		break;
	case ID_TAG_EXCHANGE:
		pVarList = ((CXISLExchangeTag*)pParentTag)->m_pLocalVar;
		break;
	default:
		ASSERT(NULL);
	}

	long lLen;
	HRESULT hr;
	IXMLDOMNodePtr spDOMVar;
	IXMLDOMNodeListPtr spDOMVarList;
	//*****_vařvf(var)擾
	spDOMParentVar->selectNodes(SysAllocString(L"var"),&spDOMVarList);
	spDOMVarList->get_length(&lLen);
	for(int i=0;i<lLen;i++)
	{
		spDOMVarList->get_item(i,&spDOMVar);
		if(spDOMVar)
		{
			IXMLDOMNodePtr spDOMName;
			IXMLDOMNodePtr spDOMExpr;
			BSTR bstrValue;
			CString strName = "";
			CString strExpr = "";

			hr = spDOMVar->selectSingleNode(SysAllocString(L"@name"),&spDOMName);
			if(FAILED(hr)) return -1;
			spDOMName->get_text(&bstrValue);
			strName = bstrValue;
			SysFreeString(bstrValue);

			hr = spDOMVar->selectSingleNode(SysAllocString(L"@expr"),&spDOMExpr);
			if(FAILED(hr)) return -1;
			if(spDOMExpr)
			{
				spDOMExpr->get_text(&bstrValue);
				strExpr = bstrValue;
			}
			SysFreeString(bstrValue);
			
			CXISLVar *pVar = new CXISLVar;
			if(pVar->SetAttribute(strName,strExpr,TRUE,FALSE) != 0)
			{
				delete pVar;pVar = NULL;
				return -1;
			}
			if(pVarList->RegistVar(pVar) != 0)
			{
				delete pVar;pVar = NULL;
				return -1;
			}
		}
	}

	return 0;
}

//int CXISLDoc::AnalyzeDialogChildren(IXMLDOMNodePtr &spDOMTargetNode,CXISLTag *pParentTag)
//dialogȉ̃m[h͂(ċAĂяop)
//IXMLDOMNodePtr &spDOMTargetNode	:Ώۃm[h
//CXISLTag *pParentTag				:ǉe^O
//F0@T|[gΏۊÕ^OF-1
//sF-2
int CXISLDoc::AnalyzeDialogChildren(IXMLDOMNodePtr &spDOMTargetNode,CXISLTag *pParentTag)
{
	//vfm[h
	DOMNodeType nodeType;
	spDOMTargetNode->get_nodeType(&nodeType);
//	if(nodeType != NODE_ELEMENT)
//		return -1;

	//^O̎擾
	BSTR bstrTagName;
	HRESULT hr = spDOMTargetNode->get_nodeName(&bstrTagName);
	if(FAILED(hr)) return -2;

	CString strTagName = bstrTagName;
	SysFreeString(bstrTagName);
	int nTagIndex=ID_TAG_DIALOG;
	while(1)
	{
		if(nTagIndex == ID_TAG_XXXX)
			return -1;
		if(strTagName.Compare(XISL_TAG_NAME[nTagIndex]) == 0)
			break;
		nTagIndex++;
	}

	CXISLTag *pResultTag = NULL;
	switch(nTagIndex)
	{
	case ID_TAG_DIALOG:
		pResultTag = CreateDialogTag(spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_BEGIN:
	case ID_TAG_END:
		pResultTag = CreateBeginEndTag(nTagIndex,spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_PEXCHANGE:
	case ID_TAG_AEXCHANGE:
	case ID_TAG_SEXCHANGE:
		pResultTag = CreateCombExcTag(nTagIndex,spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_EXCHANGE:
		pResultTag = CreateExchangeTag(spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_OPERATION:
		pResultTag = ((CXISLExchangeTag*)pParentTag)->m_pXISLOpr;
		break;
	case ID_TAG_PINPUT:
	case ID_TAG_AINPUT:
	case ID_TAG_SINPUT:
		pResultTag = CreateCombInputTag(nTagIndex,spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_INPUT:
		pResultTag = CreateInputTag(spDOMTargetNode,pParentTag);
		return 0;
	case ID_TAG_ACTION:
		if(pParentTag->m_nTagType == ID_TAG_EXCHANGE)
			pResultTag = ((CXISLExchangeTag*)pParentTag)->m_pXISLAct;
		break;
	case ID_TAG_SOUTPUT:
	case ID_TAG_POUTPUT:
		break;
	case ID_TAG_OUTPUT:
		pResultTag = CreateOutputTag(spDOMTargetNode,pParentTag);
		return 0;
	case ID_TAG_CALL:
	case ID_TAG_GOTO:
		pResultTag = CreateCallTag(nTagIndex,spDOMTargetNode,pParentTag);
		return 0;
	case ID_TAG_RETURN:
		pResultTag = CreateReturnTag(spDOMTargetNode,pParentTag);
		return 0;
	case ID_TAG_ASSIGN:
		pResultTag = CreateAssignTag(spDOMTargetNode,pParentTag);
		return 0;
	case ID_TAG_SWITCH:
		pResultTag = CreateSwitchTag(spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_CASE:
	case ID_TAG_OTHER:
		pResultTag = CreateCaseTag(nTagIndex,spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_IF:
	case ID_TAG_ELSEIF:
		pResultTag = CreateIfTag(nTagIndex,spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_THEN:
		pResultTag = ((CXISLIfTag*)pParentTag)->m_pThenTag;
		break;
	case ID_TAG_ELSE:
		pResultTag = ((CXISLIfTag*)pParentTag)->CreateElseTag();
		break;
	//PromptReprompt̉
	case ID_TAG_PROMPT:
		pResultTag = CreatePrompt(spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_REPROMPT:
		pResultTag = CreateReprompt(spDOMTargetNode,pParentTag);
		break;
	case ID_TAG_EXIT:
		((CXISLActTag*)pParentTag)->SetExit(TRUE);
		return 0;
	default:
		return -1;
	}
//	if(pResultTag == NULL)
//		return /*-2*/ 0;

	VARIANT_BOOL vbChild;
	spDOMTargetNode->hasChildNodes(&vbChild);
	if(vbChild)
	{
		IXMLDOMNodePtr spDOMChild,spDOMNext;
		spDOMTargetNode->get_firstChild(&spDOMChild);
		while(spDOMChild)
		{
			int nRet = AnalyzeDialogChildren(spDOMChild,pResultTag);
			if(nRet == -2)
				return -2;
			spDOMChild->get_nextSibling(&spDOMNext);
//			ReleaseObj(spDOMChild);
			spDOMChild = spDOMNext;
		}
	}
	return 0;
}

//CXISLDialogTag* CXISLDoc::CreateDialogTag(IXMLDOMNodePtr &spDOMDialog,CXISLTag *pParentTag)
//󂯎m[hCXISLDialogTag𐶐
//IXMLDOMNodePtr &spDOMDialog	:Ώۃm[h
//CXISLTag *pParentTag			:ǉe^O
//FIuWFNg@sFNULL
CXISLDialogTag* CXISLDoc::CreateDialogTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;

	IXMLDOMNodePtr spDOMId;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@id"),&spDOMId);
	if(FAILED(hr)) return NULL;
	spDOMId->get_text(&bstrValue);
	CString strID = bstrValue;
	SysFreeString(bstrValue);

	IXMLDOMNodePtr spDOMComb;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@comb"),&spDOMComb);
	if(FAILED(hr)) return NULL;
	spDOMComb->get_text(&bstrValue);
	CString strComb = bstrValue;
	SysFreeString(bstrValue);
	
	IXMLDOMNodePtr spDOMRepeat;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@repeat"),&spDOMRepeat);
	if(FAILED(hr)) return NULL;
	spDOMRepeat->get_text(&bstrValue);
	CString strRepeat = bstrValue;
	SysFreeString(bstrValue);

	IXMLDOMNodePtr spDOMScope;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@scope"),&spDOMScope);
	if(FAILED(hr)) return NULL;
	spDOMScope->get_text(&bstrValue);
	CString strScope = bstrValue;
	SysFreeString(bstrValue);
	
	CString strArg;
	IXMLDOMNodePtr spDOMArg;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@arg"),&spDOMArg);
	if(FAILED(hr)) return NULL;
	if(spDOMArg)
	{
		spDOMArg->get_text(&bstrValue);
		strArg = bstrValue;
		SysFreeString(bstrValue);
	}

	CXISLDialogTag *pDTag = new CXISLDialogTag;
	pDTag->m_pParentTag = m_pXISLRoot;
	if(pDTag->SetDialogAttribute(strID,strComb,strRepeat,strScope,strArg) == 0)
	{
		if(m_pXISLRoot->InsertDialogTag(pDTag))
		{
			pDTag->SetDocName(m_strFileName);
			//dialog_var̉
			IXMLDOMNodePtr spDOMNode;
			hr = spDOMTag->selectSingleNode(SysAllocString(L".//dialog_var"),&spDOMNode);
			if(spDOMNode)
			{
				if(AnalyzeVar(spDOMNode,pDTag) != 0)
				{
					//dialog^O̐Ɏs
					delete pDTag;
					pDTag = NULL;
					return NULL;
				}
			}
			return pDTag;
		}
	}

	//dialog^O̐Ɏs
	delete pDTag;
	pDTag = NULL;
	return NULL;
}

//CXISLBeginEndTag* CXISLDoc::CreateBeginEndTag(int nType,IXMLDOMNodePtr &spDOMBETag,CXISLTag *pParentTag)
//󂯎m[hBegin or End^O𐶐
//int nType						:ID_TAG_BEGIN or ID_TAG_END
//IXMLDOMNodePtr &spDOMBETag	:Ώۃm[h
//CXISLTag *pParentTag			:ǉe^O
//FIuWFNg@sFNULL
CXISLBeginEndTag* CXISLDoc::CreateBeginEndTag(int nType,IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	if(pParentTag->m_nTagType != ID_TAG_DIALOG)
		ASSERT(NULL);

	if(nType == ID_TAG_BEGIN)
		return ((CXISLDialogTag*)pParentTag)->CreateBegin();
	else if(nType == ID_TAG_END)
		return ((CXISLDialogTag*)pParentTag)->CreateEnd();
	else
		ASSERT(NULL);
	return NULL;
}

//CXISLCombExchangeTag* CreateCombExcTag(int nType,IXMLDOMNodePtr &spDOMCombExc,CXISLTag *pParentTag)
//󂯎m[h***_exchange^O𐶐
//int nType						:ID_TAG_PEXCHANGE or ID_TAG_SEXCHANGE or ID_TAG_AEXCHANGE
//IXMLDOMNodePtr &spDOMCombExc	:Ώۃm[h
//CXISLTag *pParentTag			:ǉe^O
//FIuWFNg@sFNULL
CXISLCombExchangeTag* CXISLDoc::CreateCombExcTag(int nType,IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	int nCombType;
	switch(nType)
	{
	case ID_TAG_PEXCHANGE:
		nCombType = ID_TAG_PAR;
		break;
	case ID_TAG_SEXCHANGE:
		nCombType = ID_TAG_PAR;
		break;
	case ID_TAG_AEXCHANGE:
		nCombType = ID_TAG_PAR;
		break;
	default:
		ASSERT(NULL);
	}

	if(pParentTag->m_nTagType == ID_TAG_DIALOG)
		return ((CXISLDialogTag*)pParentTag)->InsertCombExchange(nCombType);
	else if(pParentTag->m_nTagType == ID_TAG_PEXCHANGE || pParentTag->m_nTagType == ID_TAG_AEXCHANGE
		|| pParentTag->m_nTagType == ID_TAG_SEXCHANGE)
	{
		return ((CXISLCombExchangeTag*)pParentTag)->InsertCombExchange(nCombType);
	}
	else
		ASSERT(NULL);
	
	return NULL;
}


//CXISLExchangeTag* CXISLDoc::CreateExchangeTag(IXMLDOMNodePtr &spDOMExc,CXISLTag *pParentTag)
//󂯎m[hexchange^O𐶐
//IXMLDOMNodePtr &spDOMExc	:Ώۃm[h
//CXISLTag *pParentTag		:ǉe^O
//FIuWFNg@sFNULL
CXISLExchangeTag* CXISLDoc::CreateExchangeTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;
	IXMLDOMNodePtr spDOMOpr;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L".//operation"),&spDOMOpr);
	if(FAILED(hr)) return NULL;

	IXMLDOMNodePtr spDOMComb;
	hr = spDOMOpr->selectSingleNode(SysAllocString(L"@comb"),&spDOMComb);
	if(FAILED(hr)) return NULL;
	spDOMComb->get_text(&bstrValue);
	CString strComb = bstrValue;
	SysFreeString(bstrValue);
	
	CString strTarget = "";
	IXMLDOMNodePtr spDOMTarget;
	hr = spDOMOpr->selectSingleNode(SysAllocString(L"@target"),&spDOMTarget);
	if(FAILED(hr)) return NULL;
	if(spDOMTarget)
	{
		spDOMTarget->get_text(&bstrValue);
		strTarget = bstrValue;
		SysFreeString(bstrValue);
	}

	int nComb=0;
	while(1)
	{
		if(strComb.Compare(XISL_COMB[nComb]) == 0)
			break;
		nComb++;
	}
	if(pParentTag->m_nTagType == ID_TAG_DIALOG)
	{
		return ((CXISLDialogTag*)pParentTag)->InsertExchange(nComb,strTarget);
	}
	else if(pParentTag->m_nTagType == ID_TAG_SEXCHANGE
		|| pParentTag->m_nTagType == ID_TAG_PEXCHANGE
		|| pParentTag->m_nTagType == ID_TAG_AEXCHANGE)
	{
		return ((CXISLCombExchangeTag*)pParentTag)->InsertExchange(nComb,strTarget);
	}
	else
		ASSERT(NULL);

	return NULL;
}

//CXISLCombInputTag* CreateCombInputTag(int nType,IXMLDOMNodePtr &spDOMCombExc,CXISLTag *pParentTag)
//󂯎m[h***_input^O𐶐
//int nType						:ID_TAG_PEXCHANGE or ID_TAG_SEXCHANGE or ID_TAG_AEXCHANGE
//IXMLDOMNodePtr &spDOMCombExc	:Ώۃm[h
//CXISLTag *pParentTag			:ǉe^O
//FIuWFNg@sFNULL
CXISLCombInputTag* CXISLDoc::CreateCombInputTag(int nType,IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	int nCombType;
	switch(nType)
	{
	case ID_TAG_PINPUT:
		nCombType = ID_TAG_PAR;
		break;
	case ID_TAG_SINPUT:
		nCombType = ID_TAG_PAR;
		break;
	case ID_TAG_AINPUT:
		nCombType = ID_TAG_PAR;
		break;
	default:
		ASSERT(NULL);
	}

	CXISLCombInputTag *pCombInput = new CXISLCombInputTag(pParentTag,nCombType);
	if(pParentTag->m_nTagType == ID_TAG_OPERATION)
	{
		((CXISLOprTag*)pParentTag)->InsertOprItem(pCombInput);
		return pCombInput;
	}
	else if(pParentTag->m_nTagType == ID_TAG_PINPUT || pParentTag->m_nTagType == ID_TAG_AINPUT
		|| pParentTag->m_nTagType == ID_TAG_SINPUT)
	{
		((CXISLCombInputTag*)pParentTag)->InsertOprItem(pCombInput);
		return pCombInput;
	}
	else
		ASSERT(NULL);
	
	return NULL;
}

//CXISLCallTag* CXISLDoc::CreateCallTag(int nType,IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
//󂯎m[hcall,goto^O𐶐
//int nType						:ID_TAG_CALL or ID_TAG_GOTO
//IXMLDOMNodePtr &spDOMCall	:Ώۃm[h
//CXISLTag *pParentTag			:ǉe^O
//FIuWFNg@sFNULL
CXISLCallTag* CXISLDoc::CreateCallTag(int nType,IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;

	IXMLDOMNodePtr spDOMNext;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@next"),&spDOMNext);
	if(FAILED(hr)) return NULL;
	spDOMNext->get_text(&bstrValue);
	CString strNext = bstrValue;
	SysFreeString(bstrValue);
	
	CString strNameList;
	IXMLDOMNodePtr spDOMNameList;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@namelist"),&spDOMNameList);
	if(FAILED(hr)) return NULL;
	if(spDOMNameList)
	{
		spDOMNameList->get_text(&bstrValue);
		strNameList = bstrValue;
		SysFreeString(bstrValue);
	}

	CString strReturn;
	if(nType == ID_TAG_CALL)
	{
		IXMLDOMNodePtr spDOMReturn;
		hr = spDOMTag->selectSingleNode(SysAllocString(L"@return"),&spDOMReturn);
		if(FAILED(hr)) return NULL;
		if(spDOMReturn)
		{
			spDOMReturn->get_text(&bstrValue);
			strReturn = bstrValue;
			SysFreeString(bstrValue);
		}
	}

	int nIndex = strNext.Find("#");
	CString strDocName;
	CString strDiaID;
	if(nIndex == -1)
	{
		strDocName = strNext;
		strDiaID = "";
	}
	else
	{
		strDocName = strNext.Left(nIndex);
		strDiaID = strNext.Right(strNext.GetLength()-nIndex-1);
	}

	CXISLDoc *pTempDoc;
	BOOL bFind = FALSE;
	if(!strDocName.IsEmpty())
	{
		CDocTemplate* pTemplate = GetDocTemplate();
		POSITION pos = pTemplate->GetFirstDocPosition();
		while(pos)
		{
			pTempDoc = (CXISLDoc*)pTemplate->GetNextDoc(pos);
			if(strDocName.Compare(pTempDoc->GetTitle()) == 0)
			{
				bFind = TRUE;
				break;
			}
		}
	}
	else
	{
		pTempDoc = this;
		strDocName = m_strFileName;
		bFind = TRUE;
	}

	CMainFrame *pFrame = (CMainFrame*)AfxGetApp()->m_pMainWnd;
	CXISLDialogTag *pNextDTag = NULL;
	if(bFind && !strDiaID.IsEmpty())
		pNextDTag = pTempDoc->m_pXISLRoot->FindDTag(strDiaID);
	if(pNextDTag == NULL)
	{
		if(strDiaID.IsEmpty())
			strDiaID = "TOPDIALOG_IB";
		//o^ς݂̃_~[dialogH
		pNextDTag = pFrame->FindNCDTagList(strDocName,strDiaID);

		if(pNextDTag == NULL)
		{
			//_~[dialog쐬
			pNextDTag = new CXISLDialogTag;
			int nIndex = 0;
			int nCount = 0;
			if(!strNameList.IsEmpty())
			{
				while(1)
				{
					nIndex = strNameList.Find(',',nIndex);
					if(nIndex == -1)
						break;
					nCount++;nIndex++;
				}
				nCount++;
			}

			pNextDTag->SetDummy(nCount,strDocName);
			CString strName;
			for(int i=0;i<nCount;i++)
			{
				CXISLVar *pVar = new CXISLVar;
				strName.Format("%sDUMMY%d",strDiaID,i);
				pVar->SetAttribute(strName,"",FALSE,TRUE);
				if(pNextDTag->RegistDialogArg(pVar) != 0)
				{
					delete pVar; pVar = NULL;
					delete pNextDTag; pNextDTag = NULL;
					return NULL;
				}
			}
			pNextDTag->SetDocName(strDocName);
			if(pNextDTag->SetDialogAttribute(strDiaID,0,0,0) != 0)
			{
				delete pNextDTag; pNextDTag = NULL;
				return NULL;
			}
			pFrame->AddNCDTagList(pNextDTag);
		}
	}

	CXISLCallTag *pCallTag = new CXISLCallTag(nType);
	pCallTag->m_pParentTag = pParentTag;
	pCallTag->SetCallAttribute(pNextDTag,strNameList,strReturn);

	int nParentType = pParentTag->m_nTagType;
	if(nParentType == ID_TAG_ACTION || nParentType == ID_TAG_CASE || nType == ID_TAG_OTHER
		|| nParentType == ID_TAG_THEN || nParentType == ID_TAG_ELSE)
	{
		((CXISLActTag*)pParentTag)->InsertActItem(pCallTag);
		pNextDTag->AddReCallTag(pCallTag);
		return pCallTag;
	}
	else if(nParentType == ID_TAG_BEGIN || nParentType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)pParentTag)->InsertActItem(pCallTag);
		pNextDTag->AddReCallTag(pCallTag);
		return pCallTag;
	}

	pFrame->RemoveNCDTagList(pNextDTag);
	delete pCallTag; pCallTag = NULL;
	return NULL;
}

//CXISLInputTag* CXISLDoc::CreateInputTag(IXMLDOMNodePtr &spDOMInput,CXISLTag *pParentTag)
//󂯎m[hinput^O𐶐
//IXMLDOMNodePtr &spDOMCall	:Ώۃm[h
//CXISLTag *pParentTag		:ǉe^O
//FIuWFNg@sFNULL
CXISLInputTag* CXISLDoc::CreateInputTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;

	IXMLDOMNodePtr spDOMType;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@type"),&spDOMType);
	if(FAILED(hr)) return NULL;
	spDOMType->get_text(&bstrValue);
	CString strType = bstrValue;
	SysFreeString(bstrValue);

	IXMLDOMNodePtr spDOMEvent;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@event"),&spDOMEvent);
	if(FAILED(hr)) return NULL;
	spDOMEvent->get_text(&bstrValue);
	CString strEvent = bstrValue;
	SysFreeString(bstrValue);

	/*
	CString strTarget;
	IXMLDOMNodePtr spDOMTarget;
	hr = spDOMInput->selectSingleNode(SysAllocString(L"@target"),&spDOMTarget);
	if(FAILED(hr)) return NULL;
	if(spDOMTarget)
	{
		spDOMTarget->get_text(&bstrValue);
		strTarget = bstrValue;
		SysFreeString(bstrValue);
	}
	*/

	CString strMatch="";
	IXMLDOMNodePtr spDOMMatch;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@match"),&spDOMMatch);
	if(FAILED(hr)) return NULL;
	if(spDOMMatch)
	{
		spDOMMatch->get_text(&bstrValue);
		strMatch = bstrValue;
		SysFreeString(bstrValue);
	}	
	CString strReturn;
	IXMLDOMNodePtr spDOMReturn;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@return"),&spDOMReturn);
	if(FAILED(hr)) return NULL;
	if(spDOMReturn)
	{
		spDOMReturn->get_text(&bstrValue);
		strReturn = bstrValue;
		SysFreeString(bstrValue);
	}

	BOOL bOK = FALSE;
	CXISLInputTag *pInputTag=NULL;
	if(strType.Compare("speech") == 0)
	{
		if(strEvent.Compare("recognize") != 0)
		{
			AfxMessageBox("<input type=\"speech\" ...T|[gĂȂeventł",
				MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
			return NULL;
		}
		CXISLSpeechInputTag *pSITag = new CXISLSpeechInputTag;
		pSITag->m_pParentTag = pParentTag;
		if(pSITag->SetAttribute(strMatch,strReturn))
		{
			pInputTag = pSITag;
			bOK = TRUE;
		}
		else
			delete pSITag;
	}
	else if(strType.Compare("touch") == 0)
	{
		CXISLTouchInputTag *pTITag = new CXISLTouchInputTag;
		pTITag->m_pParentTag = pParentTag;
		if(pTITag->SetAttribute(strEvent,strMatch,strReturn))
		{
			pInputTag = pTITag;
			bOK = TRUE;
		}
		else
			delete pTITag;
	}

	if(bOK)
	{
		int nParentType = pParentTag->m_nTagType;
		if(nParentType == ID_TAG_OPERATION)
		{
			((CXISLOprTag*)pParentTag)->InsertOprItem(pInputTag);
			return pInputTag;
		}
		else if(nParentType == ID_TAG_PINPUT || nParentType == ID_TAG_AINPUT || nParentType == ID_TAG_SINPUT)
		{
			((CXISLCombInputTag*)pParentTag)->InsertOprItem(pInputTag);
			return pInputTag;
		}
	}

	CString strMsg;
	strMsg.Format("sF<input type=\"%s\" event=\"%s\" match=\"%s\" return=\"%s\"",strType,strEvent,strMatch,strReturn);
	AfxMessageBox(strMsg,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
	return NULL;
}

//CXISLOutputTag* CXISLDoc::CreateOutputTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
//󂯎m[hinput^O𐶐
//IXMLDOMNodePtr &spDOMOutput	:Ώۃm[h
//CXISLTag *pParentTag		:ǉe^O
//FIuWFNg@sFNULL
CXISLOutputTag* CXISLDoc::CreateOutputTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;

	IXMLDOMNodePtr spDOMType;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@type"),&spDOMType);
	if(FAILED(hr)) return NULL;
	spDOMType->get_text(&bstrValue);
	CString strType = bstrValue;
	SysFreeString(bstrValue);

	IXMLDOMNodePtr spDOMEvent;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@event"),&spDOMEvent);
	if(FAILED(hr)) return NULL;
	spDOMEvent->get_text(&bstrValue);
	CString strEvent = bstrValue;
	SysFreeString(bstrValue);

	VARIANT_BOOL vbChild;
	IXMLDOMNodePtr spDOMChild;
	spDOMTag->hasChildNodes(&vbChild);
	if(vbChild)
	{
		spDOMTag->get_firstChild(&spDOMChild);
		while(spDOMChild)
		{
			DOMNodeType nodeType;
			spDOMChild->get_nodeType(&nodeType);
			if(nodeType == NODE_CDATA_SECTION)
				break;
			spDOMTag->get_nextSibling(&spDOMChild);
		}
	}
	else
	{
		AfxMessageBox("paramȂI",MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
		return NULL;
	}

	spDOMChild->get_text(&bstrValue);
	CString strCDATA = bstrValue;
	SysFreeString(bstrValue);

	BOOL bOK = FALSE;
	CXISLOutputTag *pOutputTag=NULL;
	if(strType.Compare("tts") == 0)
	{
		CXISLOutputTTS *pTOTag = new CXISLOutputTTS;
		pTOTag->m_pParentTag = pParentTag;
		if(pTOTag->SetAttribute(strEvent,strCDATA))
		{
			pOutputTag = pTOTag;
			bOK = TRUE;
		}
		else
			delete pTOTag;
	}
	else if(strType.Compare("agent") == 0)
	{
		CXISLOutputFSM *pFOTag = new CXISLOutputFSM;
		pFOTag->m_pParentTag = pParentTag;
		if(pFOTag->SetAttribute(strEvent,strCDATA))
		{
			pOutputTag = pFOTag;
			bOK = TRUE;
		}
		else
			delete pFOTag;
	}
	else if(strType.Compare("browser") == 0)
	{
		CXISLOutputBrowser *pBOTag = new CXISLOutputBrowser;
		pBOTag->m_pParentTag = pParentTag;
		if(pBOTag->SetAttribute(strEvent,strCDATA))
		{
			pOutputTag = pBOTag;
			bOK = TRUE;
		}
		else
			delete pBOTag;
	}

	if(bOK)
	{
		int nParentType = pParentTag->m_nTagType;
		if(nParentType == ID_TAG_ACTION || nParentType == ID_TAG_CASE || nParentType == ID_TAG_OTHER
			|| nParentType == ID_TAG_THEN || nParentType == ID_TAG_ELSE)
		{
			((CXISLActTag*)pParentTag)->InsertActItem(pOutputTag);
			return pOutputTag;
		}
		else if(nParentType == ID_TAG_BEGIN || nParentType == ID_TAG_END)
		{
			((CXISLBeginEndTag*)pParentTag)->InsertActItem(pOutputTag);
			return pOutputTag;
		}
		else if(nParentType == ID_TAG_PROMPT){
			((CXISLPrompt*)pParentTag)->InsertActItem(pOutputTag);
			return pOutputTag;
		}
	}

	CString strMsg;
	strMsg.Format("sF<output type=\"%s\" event=\"%s\">",strType,strEvent);
	AfxMessageBox(strMsg,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
	return NULL;
}

//CXISLReturnTag* CXISLDoc::CreateReturnTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
//󂯎m[hreturn^O𐶐
//IXMLDOMNodePtr &spDOMCall	:Ώۃm[h
//CXISLTag *pParentTag		:ǉe^O
//FIuWFNg@sFNULL
CXISLReturnTag* CXISLDoc::CreateReturnTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;

	CString strNameList;
	IXMLDOMNodePtr spDOMNameList;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@namelist"),&spDOMNameList);
	if(FAILED(hr)) return NULL;
	if(spDOMNameList)
	{
		spDOMNameList->get_text(&bstrValue);
		strNameList = bstrValue;
		SysFreeString(bstrValue);
	}

	CXISLReturnTag *pRetTag = new CXISLReturnTag;
	pRetTag->m_pParentTag = pParentTag;
	pRetTag->SetReturnAttribute(strNameList);
	int nParentType = pParentTag->m_nTagType;
	if(nParentType == ID_TAG_ACTION || nParentType == ID_TAG_CASE || nParentType == ID_TAG_OTHER
		|| nParentType == ID_TAG_THEN || nParentType == ID_TAG_ELSE)
	{
		((CXISLActTag*)pParentTag)->InsertActItem(pRetTag);
		return pRetTag;
	}
	else if(nParentType == ID_TAG_BEGIN || nParentType == ID_TAG_END)
	{
		((CXISLBeginEndTag*)pParentTag)->InsertActItem(pRetTag);
		return pRetTag;
	}
	delete pRetTag;
	return NULL;
}

//Assign^O̍쐬
CXISLAssignTag* CXISLDoc::CreateAssignTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;

	IXMLDOMNodePtr spDOMName;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@name"),&spDOMName);
	if(FAILED(hr)) return NULL;
	spDOMName->get_text(&bstrValue);
	CString strName = bstrValue;
	SysFreeString(bstrValue);

	IXMLDOMNodePtr spDOMExpr;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@expr"),&spDOMExpr);
	if(FAILED(hr)) return NULL;
	spDOMExpr->get_text(&bstrValue);
	CString	strExpr = bstrValue;
	SysFreeString(bstrValue);

	CXISLAssignTag *pAssignTag = new CXISLAssignTag;
	pAssignTag->m_pParentTag = pParentTag;
	if(pAssignTag->SetAttribute(strName,strExpr))
	{
		int nType = pParentTag->m_nTagType;
		if(nType == ID_TAG_BEGIN || nType == ID_TAG_END)
		{
			((CXISLBeginEndTag*)pParentTag)->InsertActItem(pAssignTag);
			return pAssignTag;
		}
		else if(nType == ID_TAG_ACTION || nType == ID_TAG_CASE || nType == ID_TAG_OTHER
			|| nType == ID_TAG_THEN || nType == ID_TAG_ELSE)
		{
			((CXISLActTag*)pParentTag)->InsertActItem(pAssignTag);
			return pAssignTag;
		}
	}
	delete pAssignTag;
	return NULL;
}

//Switch^O̍쐬
CXISLSwitchTag* CXISLDoc::CreateSwitchTag(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;

	IXMLDOMNodePtr spDOMExpr;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@expr"),&spDOMExpr);
	if(FAILED(hr)) return NULL;
	spDOMExpr->get_text(&bstrValue);
	CString	strExpr = bstrValue;
	SysFreeString(bstrValue);

	CXISLSwitchTag *pSTag = new CXISLSwitchTag;
	pSTag->m_pParentTag = pParentTag;
	if(pSTag->SetAttribute(strExpr))
	{
		int nType = pParentTag->m_nTagType;
		if(nType == ID_TAG_BEGIN || nType == ID_TAG_END)
		{
			((CXISLBeginEndTag*)pParentTag)->InsertActItem(pSTag);
			return pSTag;
		}
		else if(nType == ID_TAG_ACTION || nType == ID_TAG_CASE || nType == ID_TAG_OTHER
			|| nType == ID_TAG_THEN || nType == ID_TAG_ELSE)
		{
			((CXISLActTag*)pParentTag)->InsertActItem(pSTag);
			return pSTag;
		}
	}

	delete pSTag;
	return NULL;
}

//If^O̍쐬
CXISLIfTag* CXISLDoc::CreateIfTag(int nType,IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;

	IXMLDOMNodePtr spDOMCond;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@cond"),&spDOMCond);
	if(FAILED(hr)) return NULL;
	spDOMCond->get_text(&bstrValue);
	CString	strCond = bstrValue;
	SysFreeString(bstrValue);

	CXISLIfTag *pIfTag = new CXISLIfTag(nType);
	pIfTag->m_pParentTag = pParentTag;
	if(pIfTag->SetAttribute(strCond))
	{
		int nParentType = pParentTag->m_nTagType;
		if(nType == ID_TAG_ELSEIF)
		{
			if(nParentType == ID_TAG_IF || nParentType == ID_TAG_ELSEIF)
			{
				((CXISLIfTag*)pParentTag)->AddElseIfTag(pIfTag);
				return pIfTag;
			}
			else
				ASSERT(NULL);
		}
		else
		{
			if(nParentType == ID_TAG_BEGIN || nParentType == ID_TAG_END)
			{
				((CXISLBeginEndTag*)pParentTag)->InsertActItem(pIfTag);
				return pIfTag;
			}
			else if(nParentType == ID_TAG_ACTION || nParentType == ID_TAG_CASE || nParentType == ID_TAG_OTHER
				|| nParentType == ID_TAG_THEN || nParentType == ID_TAG_ELSE)
			{
				((CXISLActTag*)pParentTag)->InsertActItem(pIfTag);
				return pIfTag;
			}
		}
	}

	delete pIfTag;
	return NULL;
}

CXISLCaseTag* CXISLDoc::CreateCaseTag(int nType,IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	CString	strValue;

	if(nType == ID_TAG_CASE)
	{
		BSTR bstrValue;

		IXMLDOMNodePtr spDOMValue;
		HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@value"),&spDOMValue);
		if(FAILED(hr)) return NULL;
		spDOMValue->get_text(&bstrValue);
		strValue = bstrValue;
		SysFreeString(bstrValue);
	}

	CXISLCaseTag *pCTag = new CXISLCaseTag(nType);
	pCTag->m_pParentTag = pParentTag;
	pCTag->SetValue(strValue);
	if(pParentTag->m_nTagType != ID_TAG_SWITCH)
		ASSERT(NULL);

	if(((CXISLSwitchTag*)pParentTag)->InsertCase(pCTag))
		return pCTag;

	return NULL;
}

//Prompt^O𐶐
CXISLPrompt* CXISLDoc::CreatePrompt(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	BSTR bstrValue;
	
	//Count̎擾
	IXMLDOMNodePtr spDOMCount;
	HRESULT hr = spDOMTag->selectSingleNode(SysAllocString(L"@count"),&spDOMCount);
	if(FAILED(hr)) return NULL;
	spDOMCount->get_text(&bstrValue);
	CString	strCount = bstrValue;
	SysFreeString(bstrValue);

	//^CAEg̎擾
	IXMLDOMNodePtr spDOMTimeout;
	CString	strTimeout;
	BOOL TimeoutState;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@timeout"),&spDOMTimeout);
	//ȗĂꍇ̓^CAEg̏ԂLqȂԂɂ
	//spDOMTimeoutNULL̏ꍇɂ
	if(spDOMTimeout==NULL){
		TimeoutState = FALSE;
	}
	else{
		TimeoutState = TRUE;
		spDOMTimeout->get_text(&bstrValue);
		strTimeout = bstrValue;
		SysFreeString(bstrValue);
	}

	//o[WC̎擾
	IXMLDOMNodePtr spDOMBargein;
	hr = spDOMTag->selectSingleNode(SysAllocString(L"@bargein"),&spDOMBargein);
	if(FAILED(hr)) return NULL;
	spDOMBargein->get_text(&bstrValue);
	CString	strBargein = bstrValue;
	SysFreeString(bstrValue);

	//^O̍쐬
	CXISLPrompt *pPTag = new CXISLPrompt(atoi(strCount.GetBuffer(strCount.GetLength())));
	pPTag->m_pParentTag = pParentTag;
	//o[WC̐ݒ
	if(strBargein == "TRUE")
		pPTag->SetBargeInAtt(TRUE);
	else if(strBargein == "FALSE")
		pPTag->SetBargeInAtt(FALSE);
	//^CAEg̐ݒ
	if(TimeoutState == TRUE){
		pPTag->SetStateTimeOut(TRUE);
		pPTag->SetTimeOut(strTimeout);
	}
	else if(TimeoutState == FALSE)
		pPTag->SetStateTimeOut(FALSE);

	//^OXgɒǉ
	if(pParentTag->m_nTagType!=ID_TAG_EXCHANGE)
		ASSERT(NULL);
	((CXISLExchangeTag *)pParentTag)->InsertPrompt(pPTag);
	return pPTag;
}

//Reprompt^O̐
CXISLRepromptTag* CXISLDoc::CreateReprompt(IXMLDOMNodePtr &spDOMTag,CXISLTag *pParentTag)
{
	CXISLRepromptTag *pRpTag = new CXISLRepromptTag(pParentTag);
	//^OXgɒǉ
	if(pParentTag->m_nTagType == ID_TAG_EXCHANGE)
	{
		CXISLActTag *pActTag;
		pActTag = ((CXISLExchangeTag*)pParentTag)->m_pXISLAct;
		if(pActTag)
			pActTag->InsertActItem(pRpTag);
		else
			ASSERT(NULL);		
	}
	else if(pParentTag->m_nTagType == ID_TAG_ACTION || pParentTag->m_nTagType == ID_TAG_CASE || pParentTag->m_nTagType == ID_TAG_OTHER || pParentTag->m_nTagType == ID_TAG_ELSE || pParentTag->m_nTagType == ID_TAG_THEN)
	{
		((CXISLActTag*)pParentTag)->InsertActItem(pRpTag);
		pRpTag->m_pParentTag=pParentTag;
	}
	else ASSERT(NULL);
	return pRpTag;
}
/******************************************************************************************
 ֐		: BOOL CXISLDoc::CreateNewData(LPCTSTR filename)
 @\		: VKXISL̍쐬
 		: filename--------- t@C
 ߂l		: BOOL ----------
 쐬		: @TH
 쐬		: 2001/10/18
 ******************************************************************************************/
BOOL CXISLDoc::CreateNewData(LPCTSTR filename)
{
	BOOL bRet = FALSE;
	CMainFrame* pFrame=(CMainFrame*)AfxGetMainWnd();

	nDoctyp |= ID_VIEW_XISL;
//	if(!strcmp(filename,""))
//		filename = "newXISL.xisl";

	m_pXISLRoot = new CXISLRootTag();
	if(g_pAppRootTag)
		m_pXISLRoot->SetAppRootName(g_pAppRootTag->GetAppRootName());
	SetModifiedFlag(TRUE);
	UpdateAllViews(NULL,nDoctyp);

	pIToolView->SendMessage(MY_UPDATE_VIEW,(WPARAM)this,nDoctyp);
	return TRUE;
}

//̃hLgXISLAvP[V[gɂ
CXISLTag* CXISLDoc::SetUpAppRoot()
{
	ASSERT(m_pXISLRoot);
	m_pXISLRoot->SetAppRoot();

	g_pAppVarList = m_pXISLRoot->m_pDocumentVar;
	POSITION pos = GetFirstViewPosition();
	while (pos != NULL)
	{
		CView* pView = GetNextView(pos);
		if (pView->IsKindOf(RUNTIME_CLASS(CIBFlowView)))
		{
			((CIBFlowView*)pView)->m_bAppRoot = TRUE;
			m_pXISLRoot->m_pDocumentVar->SetAppVar();
			return m_pXISLRoot;
		}
	}
	ASSERT(NULL);
	return NULL;
}

//CString CXISLDoc::GetXISL()
//@\@FXISLԂ
//@F
//ԂlFCString :XISL
CString CXISLDoc::GetXISL()
{
	if(m_pXISLRoot)
		return m_pXISLRoot->GetXISLString();
	return "";
}

//CString CXISLDoc::GetXISL()
//@\@FXISL̃c[ڐԂ
//@F
//ԂlFint
int CXISLDoc::GetItemCount()
{
	if(m_pXISLRoot)
		return m_pXISLRoot->GetItemCount();
	return 0;
}


//BOOL CXISLDoc::RegistXISLTree(CTreeCtrl &pTree)
//@\@Fc[Rg[XISL^Oo^
//@Fo^c[Rg[
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLDoc::RegistXISLTree(CTreeCtrl *pTree)
{
	if(m_pXISLRoot)
	{
		m_pXISLRoot->RegistXISLTree(pTree);
		return TRUE;
	}
	else
		return FALSE;
}

//dialogidL[Ƃ|C^}bv쐬
BOOL CXISLDoc::GetDialogMap(CMapStringToPtr &s2pmapDialog)
{
	ASSERT(m_pXISLRoot);

	POSITION pos = m_pXISLRoot->m_xislList.GetHeadPosition();
	while(pos)
	{
		CXISLDialogTag *pTag = (CXISLDialogTag*)m_pXISLRoot->m_xislList.GetNext(pos);
		s2pmapDialog.SetAt(pTag->GetDialogID(),pTag);
	}

	return TRUE;
}

BOOL CXISLDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	// TODO: ̈ʒuɌŗL̍쐬pR[hǉĂ
	if(m_pXISLRoot == NULL)
		return FALSE;

//	SetModifiedFlag(TRUE);
	char cPath[MAX_PATH];
	GetCurrentDirectory(MAX_PATH,cPath);
	CIBApp *pIBApp = (CIBApp*)AfxGetApp();
	pIBApp->SetSelectDir(cPath);
	return TRUE;
}
